#ifndef _fma_myri_h_
#define _fma_myri_h_

#include "libmyri.h"
#include "lf_myri_packet.h"
#include "fma_myri_packet.h"

/*
 * Generic definitions for dealing with Myrinet interfaces
 */

#define FMA_MAX_NICS 8

/*
 * Information about the Myrinet interfaces on this node
 */
struct fma_myri {

  /* count and information about each NIC */
  int num_nics;
  struct fma_nic_info **nic_info;

  lf_mac_addr_t my_max_mac;	/* Max mac addr of all my NICs */

  int local_max_nic_ports;	/* Max ports on any local NIC */
  int nic_ports;		/* max ports-per-NIC x num_nics - used to
				   figure array size for per-nic-port 
				   attributes on xbars */

  unsigned int probe_serial;	/* serial number for probes */
  unsigned int bfs_serial;	/* serial number for BFSs */

  /* This is a count of direct-connect queries in progress.  We don't
   * contact the FMS until these are all done or timed out.
   */
  int queries_in_progress;

  struct fma_probe_desc *probe_anchors;
  struct fma_probe_desc *verify_anchor;

  /* info on current mapping progress */
  int map_session_id;			/* unique session ID */
  struct fma_map_progress *map_progress;
};

/*
 * Information about one NIC
 */
struct fma_nic_info {
  int nic_id;		/* NIC "board number" */
  int nic_index;	/* index in nic_info array */
  int nic_handle;	/* used for talking to this NIC */

  struct myri_nic_info myri_info;	/* mac addr, serial no, etc. */
  struct fma_nic_reply_opaque_data *nic_reply_data;

  struct lf_channel *chp;		/* channel for detecting events */

  int ni_map_index;			/* index of this NIC in map */
  struct lf_nic *nic_ptr;		/* pointer to NIC struct */
  struct fma_route_table *route_tables;	/* 1 per port */

  int ni_xbar_id[LF_MAX_NIC_PORTS];	/* xbar ID of direct xbar, -1 = none */
  int ni_xbar_port[LF_MAX_NIC_PORTS];	/* port on xbar */

  /* probe of directly xbar */
  struct fma_probe_desc *xbar_verify_probe[LF_MAX_NIC_PORTS];

  /* some sub-fabric info */
  int *sf_ports;	/* NIC ports on this sub-fabric */
  int *sf_port_index;	/* our index in sub-fabric port array */
  int *sf_verifiers;	/* verifiers on this sub-fabric */
  int *sf_ver_index;	/* N where we are Nth verify-capable node in list */

  int mf_mapped[LF_MAX_NIC_PORTS];

  struct lf_event *nic_query_timer;	/* timer for NIC queries */

  /* results from most recent scheduled counter read (1 per port) */
  struct myri_nic_counters *last_counters;
};

static inline unsigned int
fma_myri_next_probe_serial()
{
  return A.myri->probe_serial++;
}

/*
 * Context struct used to implement callbacks
 */
struct fma_myri_send_callback {
  void (*callback_rtn)(void *);
  void *context;
};

/*
 * prototypes
 */
struct fma_nic_info *find_nip_by_id(int nic_id);
void fma_start_direct_probe(struct fma_nic_info *nip, int ifc);
void fma_note_query_completion(void);
void fma_fms_map_is_invalid(int map_version, int link_down, lf_string_t s);
int fma_myri_raw_send(int nic_id, int ifc, void *route, int route_len,
  void *txbuf, int txlen, void (*callback_rtn)(void *), void *context);
int fma_myri_sync_callback(int nic_id, int ifc,
  void (*callback_rtn)(void *), void *context);
void fma_start_nic_queries(void);
void fma_myri_handle_recv(struct fma_nic_info *nip, int port,
  struct lf_myri_packet_hdr *pkt, int length, lf_mac_addr_t sender_mac);
void fma_fill_fma_query(struct fma_myri_packet *pkt, struct fma_nic_info *nip,
  int serial, unsigned char *route, int route_len);

#endif /* _fma_myri_h_ */
